jQuery(document).ready(function ($) {
    $('.magicpay-send-reminder').on('click', function (e) {
        e.preventDefault();

        const button = $(this);
        const orderId = button.data('order-id');

        if (!orderId) {
            alert('Invalid Order ID.');
            return;
        }

        button.prop('disabled', true).text('Sending...');

        $.ajax({
            url: magicpayAdmin.ajax_url,
            method: 'POST',
            data: {
                action: 'magicpay_send_reminder',
                order_id: orderId,
                _ajax_nonce: magicpayAdmin.nonce,
            },
            success: function (response) {
                if (response.success) {
                    button.removeClass('button-primary').addClass('disabled').text('Reminder Sent');
                    alert('Reminder sent successfully!');
                } else {
                    alert(response.data.message || 'An error occurred.');
                    button.prop('disabled', false).text('Request Payment');
                }
            },
            error: function () {
                alert('An unexpected error occurred.');
                button.prop('disabled', false).text('Request Payment');
            },
        });
    });
});
