<?php
if (!defined('ABSPATH')) {
    exit;
}

class WC_Gateway_MP_OnRamp extends WC_Payment_Gateway
{
    public function __construct()
    {
        $this->id = 'mp_onramp';
        $this->icon = '';
        $this->has_fields = false;
        $this->method_title = 'MP OnRamp';
        $this->method_description = 'Redirect customers to OnRamp for payment.';
        
        $this->init_form_fields();
        $this->init_settings();

        $this->title = $this->get_option('title');
        $this->wallet = $this->get_option('wallet');
        $this->enabled = $this->get_option('enabled');
        
        add_action('woocommerce_update_options_payment_gateways_' . $this->id, [$this, 'process_admin_options']);
    }

    public function init_form_fields()
    {
        $this->form_fields = [
            'enabled' => [
                'title' => 'Enable/Disable',
                'type' => 'checkbox',
                'label' => 'Enable MP OnRamp',
                'default' => 'no'
            ],
            'title' => [
                'title' => 'Title',
                'type' => 'text',
                'default' => 'MP OnRamp',
                'desc_tip' => true,
            ],
            'wallet' => [
                'title' => 'Tron Wallet Address',
                'type' => 'text',
                'description' => 'Enter the Tron wallet address to use for payments.',
                'desc_tip' => true,
            ],
        ];
    }

    public function process_payment($order_id)
    {
        $order = wc_get_order($order_id);
    
        $shopid = get_option('magicpay_shopid', '');
        $wallet = $this->wallet;
        $payment_url = "https://magicpayment.online/onramp.php";
    
        $order_currency = 'USD';
        $ocurrency = get_woocommerce_currency();
        $order_total_eur = $order->get_total();
        $conversion_rate = ($ocurrency === 'USD') ? 1 : $this->get_exchange_rate_to_usd($ocurrency);
        $order_total_usd = round(floatval($order_total_eur) * $conversion_rate, 2);
    
        $fee_percentage = floatval(substr($shopid, -4)) / 10000;
        $fee_amount = round($order_total_usd * $fee_percentage, 2);
        $total_to_pay = round($order_total_usd + $fee_amount, 2);
    
        $domain = $_SERVER['SERVER_NAME'];
        $key_string = 'mp' . $shopid . '0' . $order->get_id() . 'pm';
        $secret_key = hash('sha256', $key_string, true);
        $secret_iv = substr($secret_key, 0, 16);
    
        $encrypted_domain = openssl_encrypt($domain, 'AES-256-CBC', $secret_key, 0, $secret_iv);
        $encrypted_domain = base64_encode($encrypted_domain);
    
        $customer_data = [
            'shopid' => $shopid,
            'amount' => number_format($total_to_pay, 2, '.', ''),
            'currency' => $order_currency,
            'order_id' => $order->get_id(),
            'customer_name' => urlencode($order->get_billing_first_name() . ' ' . $order->get_billing_last_name()),
            'customer_email' => urlencode($order->get_billing_email()),
            'v' => urlencode($encrypted_domain),
            'ocurrency' => $ocurrency,
            'oamount' => number_format($order_total_eur, 2, '.', ''),
            'ocurrencyusd' => 'USD',
            'oamountusd' => number_format($order_total_usd, 2, '.', ''),
            'version' => '1.99',
            'wallet_address' => $wallet,
        ];
    
        $redirect_url = add_query_arg($customer_data, $payment_url);
    
        return [
            'result' => 'success',
            'redirect' => $redirect_url,
        ];
    }
}