<?php
if (!defined('ABSPATH')) {
    exit;
}

add_shortcode('on_ramp', 'magicpay_on_ramp_shortcode');

function magicpay_on_ramp_shortcode()
{
    ob_start();
?>
    <div id="on-ramp-container" style="max-width: 500px; margin: 0 auto; padding: 20px; background-color:#FFFFFF; border-radius: 10px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <h2 style="text-align: center;">AUTOMATED ONRAMP</h2>
        <form id="on-ramp-form">
            <input type="text" id="shopid" name="shopid" placeholder="Shopid" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" hidden disabled />
            <input type="text" id="name" name="name" placeholder="Name" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="text" id="last_name" name="last_name" placeholder="Last Name" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="email" id="email" name="email" placeholder="Email" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="tel" id="phone" name="phone" placeholder="Phone Number" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="text" id="address" name="address" placeholder="Address" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <select id="country" name="country" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;">
                <?php foreach (WC()->countries->get_countries() as $code => $name) {
                    $selected = ($code === 'SE') ? 'selected' : '';
                    echo "<option value='{$code}' {$selected}>{$name}</option>";
                } ?>
            </select>
            <input type="text" id="postal_code" name="postal_code" placeholder="Postal Code" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="number" id="usdt_amount" name="usdt_amount" max="999" placeholder="USDT Amount (max $999)" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="text" id="wallet_address" name="wallet_address" placeholder="Wallet Address (Tron)" required style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <input type="text" id="orderid" name="orderid" placeholder="Order Id (Optional)" style="width: 99%; margin-bottom: 10px; min-height: 35px; border: 1px solid #949494; border-radius: 5px; padding: 5px;" />
            <label><input type="checkbox" id="terms" name="terms" required /> Accept Terms & Conditions</label>
            <button type="submit" style="width: 100%; background-color: #46b7e4; color: white; padding: 10px; border: none; border-radius: 5px; cursor: pointer;">PAY</button>
            <button type="button" id="fill-test-data" hidden style="width: 100%; margin-top: 10px; background-color: #ff9800; color: white; padding: 10px; border: none; border-radius: 5px; cursor: pointer;">Fill Test Data</button>
        </form>
        <div id="on-ramp-response" style="margin-top: 15px; color: red; text-align: center;"></div>
    </div>

    <script>
        document.getElementById('on-ramp-form').addEventListener('submit', async function(event) {
            event.preventDefault();
            const responseElement = document.getElementById('on-ramp-response');
            responseElement.textContent = '';

            const formData = new FormData(event.target);
            const walletAddress = formData.get('wallet_address');
            const usdtAmount = parseFloat(formData.get('usdt_amount'));

            if (!/^T[a-zA-Z0-9]{33}$/.test(walletAddress)) {
                responseElement.textContent = 'Invalid Tron wallet address. Please try again.';
                return;
            }
            if (isNaN(usdtAmount) || usdtAmount > 999) {
                responseElement.textContent = 'The USDT amount must be $999 or less.';
                return;
            }

            responseElement.textContent = 'Processing...';

            try {
                const response = await fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
                    method: 'POST',
                    body: new URLSearchParams({
                        action: 'create_onramp_order',
                        ...Object.fromEntries(formData)
                    }),
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                });

                if (!response.ok) throw new Error('Network error');

                const result = await response.json();

                if (result.success && result.data && result.data.redirect) {
                    const redirectUrl = result.data.redirect;
                    if (redirectUrl.startsWith('http')) {
                        window.location.href = redirectUrl;
                    } else {
                        responseElement.textContent = 'Invalid redirect URL. Please try again.';
                    }
                } else {
                    responseElement.textContent = result.message || 'An error occurred. Please try again.';
                }
            } catch (error) {
                responseElement.textContent = 'An error occurred while processing your request.';
            }
        });

        document.getElementById('fill-test-data').addEventListener('click', function() {
            document.getElementById('name').value = 'Test';
            document.getElementById('last_name').value = 'Test';
            document.getElementById('email').value = 'info@ajginvestment.com';
            document.getElementById('phone').value = '3344556677';
            document.getElementById('address').value = 'Test Address';
            document.getElementById('country').value = 'US';
            document.getElementById('postal_code').value = '33536';
            document.getElementById('usdt_amount').value = '100';
            document.getElementById('wallet_address').value = 'TQ8FABCAtBBca7fnfdDqnJshDv9rfeZDtb';
        });
    </script>
<?php
    return ob_get_clean();
}

add_action('wp_ajax_create_onramp_order', 'create_onramp_order');
add_action('wp_ajax_nopriv_create_onramp_order', 'create_onramp_order');

function create_onramp_order()
{
    $required_fields = ['name', 'last_name', 'email', 'phone', 'address', 'country', 'postal_code', 'usdt_amount', 'wallet_address'];
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) wp_send_json_error(['message' => ucfirst($field) . ' is required.']);
    }

    if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        wp_send_json_error(['message' => 'Invalid email address.']);
    }

    if (!preg_match('/^T[a-zA-Z0-9]{33}$/', $_POST['wallet_address'])) {
        wp_send_json_error(['message' => 'Invalid Tron wallet address.']);
    }

    $usdt_amount = floatval($_POST['usdt_amount']);
    if ($usdt_amount > 999) {
        wp_send_json_error(['message' => 'The USDT amount must be $999 or less.']);
    }

    $product_name = "Fee for buying and sending $usdt_amount USDT to wallet " . sanitize_text_field($_POST['wallet_address']);

    $order = wc_create_order();
    if (is_wp_error($order)) {
        wp_send_json_error(['message' => 'Could not create order.']);
    }

    $order->set_billing_first_name(sanitize_text_field($_POST['name']));
    $order->set_billing_last_name(sanitize_text_field($_POST['last_name']));
    $order->set_billing_email(sanitize_email($_POST['email']));
    $order->set_billing_phone(sanitize_text_field($_POST['phone']));
    $order->set_billing_address_1(sanitize_text_field($_POST['address']));
    $order->set_billing_country(sanitize_text_field($_POST['country']));
    $order->set_billing_postcode(sanitize_text_field($_POST['postal_code']));
    $order->set_created_via('onramp');

    $item = new WC_Order_Item_Product();
    $item->set_name($product_name);
    $item->set_quantity(1);
    $item->set_total($usdt_amount);
    $order->add_item($item);

    $order->calculate_totals();
    $order->save();

    $order_prefix = get_option('magicpay_order_prefix', '');

    $custom_order_id = !empty($_POST['orderid']) 
        ? sanitize_text_field($_POST['orderid']) 
        : ($order_prefix ? $order_prefix . '-' : '') . $order->get_id();

    $order->update_meta_data('_custom_order_id', $custom_order_id);
    $order->save();

    $payment_gateway = WC()->payment_gateways()->payment_gateways()['magicpay'];
    $result = $payment_gateway->process_payment($order->get_id());

    if ($result && isset($result['result']) && $result['result'] === 'success') {
        wp_send_json_success([
            'redirect' => add_query_arg('orderid', $custom_order_id, $result['redirect']),
        ]);
    } else {
        wp_send_json_error(['message' => 'Payment failed.']);
    }
}
